@extends('layouts.app')

@section('title', 'Dashboard')

@section('content')
<div class="dashboard-page">
    <div class="container">
        <h1>Welcome, {{ auth()->user()->name }}!</h1>
        
        <div class="dashboard-actions">
            <a href="{{ route('tickets.create') }}" class="btn btn-primary">Create New Ticket</a>
            <a href="{{ route('tickets.index') }}" class="btn btn-secondary">View All Tickets</a>
        </div>

        <div class="tickets-section">
            <h2>Your Recent Tickets</h2>
            @if($tickets->count() > 0)
                <div class="tickets-list">
                    @foreach($tickets as $ticket)
                        <div class="ticket-card">
                            <div class="ticket-header">
                                <h3><a href="{{ route('tickets.show', $ticket) }}">{{ $ticket->subject }}</a></h3>
                                <span class="badge badge-{{ $ticket->status }}">{{ ucfirst($ticket->status) }}</span>
                            </div>
                            <p class="ticket-description">{{ Str::limit($ticket->description, 100) }}</p>
                            <div class="ticket-meta">
                                <span>Priority: {{ ucfirst($ticket->priority) }}</span>
                                <span>Created: {{ $ticket->created_at->format('M d, Y') }}</span>
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <p>You don't have any tickets yet. <a href="{{ route('tickets.create') }}">Create your first ticket</a></p>
            @endif
        </div>
    </div>
</div>
@endsection

